/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*-
 * Copyright (c) 2003
 *	Bill Paul <wpaul@windriver.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/systm.h>
#include <sys/lock.h>
#include <sys/mutex.h>
#include <sys/proc.h>

#include <sys/asm_linkage.h>
#include <sys/panic.h>
#include <sys/regset.h>
#include <sys/reboot.h>
#include <sys/psw.h>

#include <sys/callo.h>
#include <sys/sunddi.h>
#include <sys/ddi.h>
#include <sys/atomic.h>
#include <sys/condvar.h>
#include <sys/thread.h>
#include <sys/cmn_err.h>
#include "queue.h"
#include "pe_var.h"
#include "cfg_var.h"
#include "ntoskrnl_var.h"
#include "hal_var.h"
#include "if_ieee80211.h"
#include "resource_var.h"
#include "ndis_var.h"
#include "if_ndisvar.h"
//=============
#if 0
#include <sys/param.h>
#include <sys/types.h>
#include <sys/errno.h>

#include <sys/lock.h>
#include <sys/mutex.h>
#include <sys/proc.h>
#include <sys/cmn_err.h>

#include <sys/systm.h>
#include <sys/cpuvar.h>
#include <sys/machlock.h>
#include <sys/spl.h>
#include <sys/thread.h>
#include <sys/disp.h>
#include "queue.h"
#include "pe_var.h"
#include "cfg_var.h"
#include "ntoskrnl_var.h"
#include "hal_var.h"
#include "resource_var.h"
#endif
__stdcall static void KeStallExecutionProcessor(uint32_t);
__stdcall static void WRITE_PORT_BUFFER_ULONG(uint32_t *,
	uint32_t *, uint32_t);
__stdcall static void WRITE_PORT_BUFFER_USHORT(uint16_t *,
	uint16_t *, uint32_t);
__stdcall static void WRITE_PORT_BUFFER_UCHAR(uint8_t *,
	uint8_t *, uint32_t);
__stdcall static void WRITE_PORT_ULONG(uint32_t *, uint32_t);
__stdcall static void WRITE_PORT_USHORT(uint16_t *, uint16_t);
__stdcall static void WRITE_PORT_UCHAR(uint8_t *, uint8_t);
__stdcall static uint32_t READ_PORT_ULONG(uint32_t *);
__stdcall static uint16_t READ_PORT_USHORT(uint16_t *);
__stdcall static uint8_t READ_PORT_UCHAR(uint8_t *);
__stdcall static void READ_PORT_BUFFER_ULONG(uint32_t *,
	uint32_t *, uint32_t);
__stdcall static void READ_PORT_BUFFER_USHORT(uint16_t *,
	uint16_t *, uint32_t);
__stdcall static void READ_PORT_BUFFER_UCHAR(uint8_t *,
	uint8_t *, uint32_t);
__stdcall static uint64_t KeQueryPerformanceCounter(uint64_t *);
//__stdcall static void dummy (int);

extern kmutex_t	sched_lock;
unsigned int critical_lock;
int
hal_libinit()
{
	image_patch_table	*patch;
	__FUNCNAME__;
	patch = hal_functbl;
	while (patch->ipt_func != NULL) {
		windrv_wrap((funcptr)patch->ipt_func,
		    (funcptr *)&patch->ipt_wrap);
		patch++;
	}

	return(0);
}

int
hal_libfini()
{
	image_patch_table	*patch;

	__FUNCNAME__;
	patch = hal_functbl;
	while (patch->ipt_func != NULL) {
		windrv_unwrap(patch->ipt_wrap);
		patch++;
	}

	return(0);
}

__stdcall static void
KeStallExecutionProcessor(usecs)
	uint32_t		usecs;
{
	int x;
	__FUNCNAME__;
	drv_usecwait(usecs);
	return;
}

__stdcall static void
WRITE_PORT_ULONG(port, val)
	uint32_t		*port;
	uint32_t		val;
{
	__FUNCNAME__;
	if((uintptr_t)port == 0x5080) cmn_err(CE_CONT,"%s(0x%p,0x%x)\n",__func__, port, val);
	ddi_put32(global_sc->ndis_PCI_bar1_handle, (uint32_t *)port, val);
	//__asm__ __volatile("outl %0,%%dx" : : "a"(val), "d"(port) );
	return;
}

__stdcall static void
WRITE_PORT_USHORT(port, val)
	uint16_t		*port;
	uint16_t		val;
{
	__FUNCNAME__S;
	if((uintptr_t)port == 0x5080) cmn_err(CE_CONT,"%s(0x%p,0x%x)\n",__func__, port, val);
	ddi_put16(global_sc->ndis_PCI_bar1_handle, (uint16_t *)port, val);
	//__asm__ __volatile("outw %0,%%dx" : : "a"(val), "d"(port) );
	return;
}

__stdcall static void
WRITE_PORT_UCHAR(port, val)
	uint8_t			*port;
	uint8_t			val;
{
	__FUNCNAME__S;
	if((uintptr_t)port == 0x5080) cmn_err(CE_CONT,"%s(0x%p,0x%x)\n",__func__, port, val);
	ddi_put8(global_sc->ndis_PCI_bar1_handle, (uint8_t *)port, val);
	//__asm__ __volatile("outb %0,%%dx" : : "a"(val), "d"(port) );
	return;
}

__stdcall static void
WRITE_PORT_BUFFER_ULONG(port, val, cnt)
	uint32_t		*port;
	uint32_t		*val;
	uint32_t		cnt;
{
	int			i;

	__FUNCNAME__;
	for (i = 0; i < cnt; i++)
		WRITE_PORT_ULONG(port + i, val[i]);
	return;
}

__stdcall static void
WRITE_PORT_BUFFER_USHORT(port, val, cnt)
	uint16_t		*port;
	uint16_t		*val;
	uint32_t		cnt;
{
	int			i;

	__FUNCNAME__;
	for (i = 0; i < cnt; i++)
		WRITE_PORT_USHORT(port + i, val[i]);
	return;
}

__stdcall static void
WRITE_PORT_BUFFER_UCHAR(port, val, cnt)
	uint8_t			*port;
	uint8_t			*val;
	uint32_t			cnt;
{
	int			i;

	__FUNCNAME__;
	for (i = 0; i < cnt; i++)
		WRITE_PORT_UCHAR(port + i, val[i]);

	return;
}

__stdcall static uint16_t
READ_PORT_USHORT(port)
	uint16_t		*port;
{
	uint16_t		data;

	__FUNCNAME__S;
	data = ddi_get16(global_sc->ndis_PCI_bar1_handle, port);
	//__asm ("inw %%dx,%0" : "=a" (data) : "d" (port));
	return (data);
}

__stdcall static uint32_t
READ_PORT_ULONG(port)
	uint32_t		*port;
{
	uint32_t		data;

	__FUNCNAME__S;
	data = ddi_get32(global_sc->ndis_PCI_bar1_handle, port);
	//cmn_err(CE_CONT,"%s(0x%p,0x%x)\n",__func__, port,data);
	//__asm ("inl %%dx,%0" : "=a" (data) : "d" (port));
	return(data);
}

__stdcall static uint8_t
READ_PORT_UCHAR(port)
	uint8_t			*port;
{
	uint8_t			data;

	__FUNCNAME__S;
	data = ddi_get8(global_sc->ndis_PCI_bar1_handle, port);
	//__asm ("inb %%dx,%0" : "=a" (data) : "d" (port));
	return(data);
}

__stdcall static void
READ_PORT_BUFFER_ULONG(port, val, cnt)
	uint32_t		*port;
	uint32_t		*val;
	uint32_t		cnt;
{
	int			i;

	__FUNCNAME__S;
	for (i = 0; i < cnt; i++)
		val[i] = READ_PORT_ULONG(port + i);

	return;
}

__stdcall static void
READ_PORT_BUFFER_USHORT(port, val, cnt)
	uint16_t		*port;
	uint16_t		*val;
	uint32_t		cnt;
{
	int			i;
	__FUNCNAME__S;

	for (i = 0; i < cnt; i++)
		val[i] = READ_PORT_USHORT(port + i);

	return;
}

__stdcall static void
READ_PORT_BUFFER_UCHAR(port, val, cnt)
	uint8_t			*port;
	uint8_t			*val;
	uint32_t		cnt;
{
	int			i;
	__FUNCNAME__S;

	for (i = 0; i < cnt; i++)
		val[i] = READ_PORT_UCHAR(port + i);

	return;
}

__fastcall uint8_t
KfAcquireSpinLock(REGARGS1(kspin_lock *lock))
{
	uint8_t			oldirql;

	__FUNCNAME__;
	/* I am so going to hell for this. */
	if (KeGetCurrentIrql() > DISPATCH_LEVEL)
		panic("IRQL_NOT_LESS_THAN_OR_EQUAL");

	oldirql = KeRaiseIrql(DISPATCH_LEVEL);
	KeAcquireSpinLockAtDpcLevel(lock);

	return(oldirql);
}

__fastcall void
KfReleaseSpinLock(REGARGS2(kspin_lock *lock, uint8_t newirql))
{
	__FUNCNAME__;
	KeReleaseSpinLockFromDpcLevel(lock);
	KeLowerIrql(newirql);

	return;
}
#define DPLS	169
#define AT_DISPATCH_LEVEL(td)		\
	((td)->t_pri == DPLS)

__stdcall uint8_t
KeGetCurrentIrql(void)
{
	__FUNCNAME__;
	if(AT_DISPATCH_LEVEL(curthread))
		return(DISPATCH_LEVEL);
	return (PASSIVE_LEVEL);
}

/*Need more work*/
__stdcall static uint64_t
KeQueryPerformanceCounter(freq)
	uint64_t		*freq;
{
	__FUNCNAME__;
	if (freq != NULL)
		*freq = hz;

	return((uint64_t)ddi_get_lbolt());
}

__fastcall uint8_t
KfRaiseIrql(REGARGS1(uint8_t irql))
{
	uint8_t			oldirql;
	__FUNCNAME__;
	if (irql < KeGetCurrentIrql())
		;
	if (KeGetCurrentIrql() == DISPATCH_LEVEL)
		return(DISPATCH_LEVEL);
	return(oldirql);
}

__fastcall void 
KfLowerIrql(REGARGS1(uint8_t oldirql))
{
	__FUNCNAME__;
	if (oldirql == DPLS)
		return;

	if (KeGetCurrentIrql() > DISPATCH_LEVEL)
		panic("IRQL_NOT_GREATER_THAN");
	return;
}

__stdcall
static void dummy_hal(void)
{
	cmn_err(CE_WARN,"dummy hal, api lost\n");
	return;
}

image_patch_table hal_functbl[] = {
	IMPORT_FUNC(KeStallExecutionProcessor),
	IMPORT_FUNC(WRITE_PORT_ULONG),
	IMPORT_FUNC(WRITE_PORT_USHORT),
	IMPORT_FUNC(WRITE_PORT_UCHAR),
	IMPORT_FUNC(WRITE_PORT_BUFFER_ULONG),
	IMPORT_FUNC(WRITE_PORT_BUFFER_USHORT),
	IMPORT_FUNC(WRITE_PORT_BUFFER_UCHAR),
	IMPORT_FUNC(READ_PORT_ULONG),
	IMPORT_FUNC(READ_PORT_USHORT),
	IMPORT_FUNC(READ_PORT_UCHAR),
	IMPORT_FUNC(READ_PORT_BUFFER_ULONG),
	IMPORT_FUNC(READ_PORT_BUFFER_USHORT),
	IMPORT_FUNC(READ_PORT_BUFFER_UCHAR),
	IMPORT_FUNC(KfAcquireSpinLock),
	IMPORT_FUNC(KfReleaseSpinLock),
	IMPORT_FUNC(KeGetCurrentIrql),
	IMPORT_FUNC(KeQueryPerformanceCounter),
	IMPORT_FUNC(KfLowerIrql),
	IMPORT_FUNC(KfRaiseIrql),

	/*
	 * This last entry is a catch-all for any function we haven't
	 * implemented yet. The PE import list patching routine will
	 * use it for any function that doesn't have an explicit match
	 * in this table.
	 */

	{ NULL, (FUNC)dummy_hal, NULL },

	/* End of list. */

	{ NULL, NULL, NULL }
};
