/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Copyright (c) 2003
 *      Bill Paul <wpaul@windriver.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */


#define W_MAX	16

struct section {
	const char *	name;

	TAILQ_ENTRY(section)	link;
};
TAILQ_HEAD(section_head, section);

struct assign {
	struct section	*section;

	const char *	key;
	const char *	vals[W_MAX];

	TAILQ_ENTRY(assign)	link;
};
TAILQ_HEAD(assign_head, assign);

struct reg {
	struct section *section;

	const char *	root;
	const char *	subkey;
	const char *	key;
	u_int		flags;
	const char *	value;

	TAILQ_ENTRY(reg)	link;
};
TAILQ_HEAD(reg_head, reg);

#define	FLG_ADDREG_TYPE_SZ		0x00000000
#define	FLG_ADDREG_BINVALUETYPE		0x00000001
#define	FLG_ADDREG_NOCLOBBER		0x00000002
#define	FLG_ADDREG_DELVAL		0x00000004
#define	FLG_ADDREG_APPEND		0x00000008
#define	FLG_ADDREG_KEYONLY		0x00000010
#define	FLG_ADDREG_OVERWRITEONLY	0x00000020
#define	FLG_ADDREG_64BITKEY		0x00001000
#define	FLG_ADDREG_KEYONLY_COMMON	0x00002000
#define	FLG_ADDREG_32BITKEY		0x00004000
#define	FLG_ADDREG_TYPE_MULTI_SZ	0x00010000
#define	FLG_ADDREG_TYPE_EXPAND_SZ	0x00020000
#define	FLG_ADDREG_TYPE_DWORD		0x00010001
#define	FLG_ADDREG_TYPE_NONE		0x00020001

extern void	section_add	(const char *);
extern void	assign_add	(const char *);
extern void	define_add	(const char *);
extern void	regkey_add	(const char *);

extern void	push_word	(const char *);
extern void	clear_words	(void);
extern int	inf_parse	(FILE *, FILE *);
