/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*-
 * Copyright (c) 2003
 *	Bill Paul <wpaul@windriver.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: /repoman/r/ncvs/src/sys/dev/if_ndis/if_ndisvar.h,v 1.19 2005/02/16 05:41:17 wpaul Exp $
 */
#ifndef _IF_NDISVAR_H_
#define _IF_NDISVAR_H_

#include <mac.h>
#include <mac_wifi.h>

#define NDIS_DEFAULT_NODENAME	"FreeBSD NDIS node"
#define NDIS_NODENAME_LEN	32
#define ETHER_ADDR_LEN 6

struct ndis_pci_type {
	uint16_t		ndis_vid;
	uint16_t		ndis_did;
	uint32_t		ndis_subsys;
	char			*ndis_name;
};

struct ndis_pccard_type {
	const char		*ndis_vid;
	const char		*ndis_did;
	char			*ndis_name;
};

typedef struct {
	ddi_acc_handle_t	acc_hdl;	/* handle for memory */
	caddr_t			mem_va;		/* CPU VA of memory */
	uint32_t		nslots;		/* number of slots */
	uint32_t		size;		/* size per slot */
	size_t			alength;	/* allocated size */
						/* >= product of above */

	ddi_dma_handle_t	dma_hdl;	/* DMA handle */
	offset_t		offset;		/* relative to handle */
	ddi_dma_cookie_t	cookie;		/* associated cookie */
	uint32_t		ncookies;	/* must be 1 */
	uint32_t		token;		/* arbitrary identifier */
} my_dma_area_t;					/* 0x50 (80) bytes */

struct ndis_shmem {
	ddi_dma_attr_t	*accattr;
	my_dma_area_t	bf_dma;
	void			*ndis_saddr;
	uint32_t 		shm_len;
	physaddr		phyaddr;
	struct ndis_shmem	*ndis_next;
};

struct ndis_cfglist {
	ndis_cfg		ndis_cfg;
        TAILQ_ENTRY(ndis_cfglist)	link;
};

TAILQ_HEAD(nch, ndis_cfglist);

struct ntmemlist {
	uintptr_t		*addr;
	uint32_t		len;
    TAILQ_ENTRY(ntmemlist)	link;
};

TAILQ_HEAD(nml, ntmemlist);


#define NDIS_INITIALIZED(sc)	(sc->ndis_block->nmb_miniportadapterctx != NULL)

#define NDIS_INC(x)		\
	(x)->ndis_txidx = ((x)->ndis_txidx + 1) % (x)->ndis_maxpkts 
#define arpcom ic.ic_ac

struct ndis_softc {
	mac_handle_t		ndis_mh;
	struct ieee80211com	ic;		/* interface info */
	dev_info_t 		*devinfo_this;
	uint8_t 		ndis_mac_addr[ETHERADDRL];
	u_long			ndis_hwassist;
	uint32_t		ndis_v4tx;
	uint32_t		ndis_v4rx;
	void			*ndis_intrhand;
	int			ndis_rescnt;
	kmutex_t		ndis_mtx;
	kmutex_t		ndis_intrmtx;
	int			ndis_unit;
	ndis_miniport_block	*ndis_block;
	ndis_miniport_characteristics	*ndis_chars;
	interface_type		ndis_type;
	int			ndis_maxpkts;
	ndis_oid		*ndis_oids;
	int			ndis_oidcnt;
	int			ndis_txidx;
	int			ndis_txpending;
	ndis_packet		**ndis_txarray;
	ndis_handle		ndis_txpool;
	int			ndis_sc;
	ndis_cfg		*ndis_regvals;
	struct nch		ndis_cfglist_head;
	int			ndis_80211;
	int			ndis_link;
	uint32_t		ndis_filter;
	int			ndis_if_flags;
	int			ndis_skip;

	int			ndis_devidx;
	interface_type		ndis_iftype;

	struct ndis_shmem	*ndis_shlist;

	int			ndis_mmapcnt;
	void			*ioreg_ndis[6];
	void			*ioport_ndis;
	ddi_acc_handle_t ndis_PCI_bar1_handle;
	ddi_acc_handle_t ndis_PCI_bar2_handle[6];
	ddi_acc_handle_t	pci_head_hdl;
	ddi_acc_handle_t	sc_cfg_handle;	/* DDI I/O handle */
	ddi_acc_handle_t	sc_io_handle;	/* DDI I/O handle */
	ddi_iblock_cookie_t	sc_iblock;
	ddi_softintr_t		ndis_softintr_id;
	uintptr_t		*baseIOaddr;
	timeout_id_t		ndis_stat_ch;
	int32_t			ndis_promisc;
	uint8_t			*sc_mcast;
	uint32_t		sc_mcast_count;
	uint32_t		sc_mcast_len;
	int			ndis_firstdone;
	int			ndis_suspended;
};
#define NDIS_LOCK(_sc)		mutex_enter(&(_sc)->ndis_mtx)
#define NDIS_UNLOCK(_sc)	mutex_exit(&(_sc)->ndis_mtx)
#define INTR_LOCK(sc)		mutex_enter(&(sc)->ndis_intrmtx)
#define INTR_UNLOCK(sc)		mutex_exit(&(sc)->ndis_intrmtx)

#ifndef GLD_SUCCESS
#define NDIS_SUCCESS 0x0
#define NDIS_FAILURE 0X1
#define GLD_SUCCESS NDIS_SUCCESS
#define GLD_FAILURE NDIS_FAILURE
#else
#define NDIS_SUCCESS 0x0
#define NDIS_FAILURE 0X1
#endif

#endif
